/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.mods.scrollabletooltips;

import club.sk1er.mods.scrollabletooltips.Config;
import gg.essential.universal.UKeyboard;
import gg.essential.universal.UScreen;
import net.minecraft.class_1735;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class TooltipScroller {
    public static boolean needsReset;
    public static boolean allowScrolling;
    public static double scrollX;
    public static double scrollY;
    public static float zoomFactor;
    public static class_1735 currentSlot;

    public static void translateTooltip(class_4587 matrixStack, int tooltipY, int tooltipHeight) {
        class_437 screen = UScreen.getCurrentScreen();
        assert (screen != null);
        if (needsReset) {
            scrollX = 0.0;
            allowScrolling = tooltipHeight + 12 > screen.field_22790 || Math.abs(tooltipY) + tooltipHeight > screen.field_22790;
            scrollY = allowScrolling && Config.startAtTop ? (double)(6 - tooltipY) : 0.0;
            zoomFactor = 1.0f;
            needsReset = false;
        }
        if (!Config.masterToggle) {
            return;
        }
        if (allowScrolling) {
            int max = 6 - tooltipY;
            int min = screen.field_22790 - tooltipY - tooltipHeight - 6;
            if (scrollY > (double)max) {
                scrollY = max;
            } else if (scrollY < (double)min) {
                scrollY = min;
            }
        }
        matrixStack.method_22904(scrollX, scrollY, 0.0);
        matrixStack.method_22905(zoomFactor, zoomFactor, 1.0f);
    }

    public static void resetScroll() {
        needsReset = true;
        allowScrolling = false;
    }

    public static boolean scroll(double delta) {
        if (allowScrolling) {
            if (UKeyboard.isCtrlKeyDown() && Config.zoom) {
                zoomFactor *= (float)(1.0 + 0.1 * Math.signum(delta));
                return true;
            }
            if (UKeyboard.isShiftKeyDown() && Config.horizontalScrolling) {
                scrollX += 10.0 * Math.signum(delta);
                return true;
            }
            if (Config.verticalScrolling) {
                scrollY += 10.0 * Math.signum(delta);
                return true;
            }
        }
        return false;
    }

    static {
        scrollX = 0.0;
        scrollY = 0.0;
        zoomFactor = 1.0f;
    }
}

